import org.serviio.library.metadata.*
import org.serviio.library.online.*
import org.serviio.util.*
import java.util.zip.GZIPInputStream;

/********************************************************************
 * SkysportsPlus plugin for Serviio
 * 
 * author JHB50 based on cricfreetv by X S Inattar 
 *
 * URL to use as video webresource: http://www.skysports.plus/
 *
 * Also displays next 2 scheduled events for each channel
 * For complete schedule see http://www.cricfree.tv/
 *
 * Version:
 *    V1: - Nov 25, 2012 - Initial Release
 *    V2: - Dec  3, 2012 - New cricfree format
 *    V3: - Dec  4, 2012 - Better Schedule matching, new time parameter
 *    V4: - Dec  6, 2012 - Correct sched format & midnight time stamp
 *    V5: - Dec  7, 2012 - correct parameter processing
 *    V6: - Dec  8, 2012 - support new channels sentanta australia and ireland
 *    V7: - Dec  8, 2012 - New cricfree format
 *    V8: - Dec  8, 2012 - New liveflash uri
 *    V9: - Dec 13, 2012 - Update to work if no schedule found
 *    V10:- Dec 16, 2012 - New yycast uri, add channel names
 *    V11:- Dec 23, 2012 - Add hdmytv, liveflash and leton links
 *    V12:- Dec 25, 2012 - Add dummy item if no feed items found
 *    V13:- Dec 31, 2012 - verify network active before parsing
 *    V14:- Feb  3, 2013 - Add "ten" and starsports channels, more sources, put time first, Genurls added by default to minimize extracts
 *    V15:- Feb. 5, 2013 - Fix Reextract logic, adjust schedule time.
 *    V16:- Feb.10, 2013 - Adjust Schedule time to reflect change from CET to GMT
 *    V17:- Feb.17, 2013 - Add new source livego
 *    V18:- Feb.23, 2013 - Add ESPN USA
 *    V19:- Feb.26, 2013 - Add new source cast4you
 *    V20:- Mar. 2, 2013 - Add Sky Sports F1
 *    V21:- Mar.10, 2013 - Increase Extract Timeout to 90 seconds 
 *    V22:- Mar.14, 2013 - Add new sources castalba & reyhq & fix setanta
 *    V23:- Mar.20, 2013 - new reyhq uri
 *    V24:- Apr.18, 2013 - Add IPL channel, new sources ezcast and goodcast, new leton uri
 *
 ********************************************************************/
 
 class SkysportsPlus extends WebResourceUrlExtractor {

	long StartETime = 0
	long LastETime2 = 0
	long LastETime3 = 0

	List<WebResourceItem> newitems = []
	List<WebResourceItem> olditems = []

	final VALID_RESOURCE_URL = '^http://www.skysports.plus.*?'
	final BASE_URL = 'http://www.cricfree.tv/'
	final BASE_IMAGE_URL = 'https://sites.google.com/site/serviiorss'
	String secCode = ''
	
	String ucasterUri
	String mipsUri
	String liveflashUri

	String getExtractorName() {
	return 'skysportsplus'
	}
    
	boolean extractorMatches(URL resourceUrl) {
		return resourceUrl ==~ VALID_RESOURCE_URL
	}

	int getVersion() {
		return 24
	}

	int getExtractItemsTimeout() {
		return 90
	}	
	
	Long ETimer(String msg){
		long CurrentTime = System.currentTimeMillis()
		long Elapsed = CurrentTime - StartETime
		if (msg != null){
			log("$msg = $Elapsed msec")
		}
		return Elapsed
	}

	Long ETimer2(String msg){
		long CurrentTime = System.currentTimeMillis()
		long Elapsed = CurrentTime - LastETime2
		LastETime2 = CurrentTime
		if (msg != null){
			log("$msg = $Elapsed msec")
		}
		return Elapsed
	}
	
	Long ETimer3(String msg){
		long CurrentTime = System.currentTimeMillis()
		long Elapsed = CurrentTime - LastETime3
		LastETime3 = CurrentTime
		if (msg != null){
			log("$msg = $Elapsed msec")
		}
		return Elapsed
	}

	Boolean URLExists(String srcURL){
		URL fileURL = new URL(srcURL);
		if(((HttpURLConnection) fileURL.openConnection()).getResponseCode() == 404){
			return false
		}
		return true
	}
	
	String OpenProtURL(String srcURL,String Referrer) {        

		def rv = ""
		URL url = new URL(srcURL);
		URLConnection conn = url.openConnection();
		conn.setRequestProperty("Referer", Referrer);
		conn.setDoOutput(true);

		BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
		String line;
		while ((line = rd.readLine()) != null) {
			rv += line
		}
		rd.close();
		return rv
	}

	Boolean channelOffline(
		String htmlText, 
		String offlineChecker
	) {
		def offline_check = htmlText =~ offlineChecker
		if (offline_check.count > 0) {
			return true
		}
		return false
	}

	Boolean streamNotSupported(
		String htmlText, 
		String streamNotSupportedChecker
	) {
		def notsupported_check = htmlText =~ streamNotSupportedChecker
		if (notsupported_check.count > 0) {
			return true
		}
		return false
	}

    String fix_playpath(String playpath) {
        def actual_playpath = playpath
        
        actual_playpath = actual_playpath.replaceAll(".flv", "")
        actual_playpath = java.net.URLDecoder.decode(actual_playpath)
        
        return actual_playpath
    } 
        
    String process_for_URL(        
        String htmlText,
        String rgxMatcher,
        String baseURL
    ) {       
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
            return_val = '-URL-' + baseURL + matcher[0][1]
        }        
        return return_val
    }
    
    String process_for_PLAYPATH(
        String htmlText,
        String rgxMatcher,
        String[] streamURLs,
        String baseURL,
        String swfURL        
    ) {        
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
            
            def pageURL = baseURL + matcher[0][1]
            
            def playpath = fix_playpath(matcher[0][1])            
            
            def stream = streamURLs[ (int)(System.currentTimeMillis() % streamURLs.size()) ]
            
			secCode = playpath
            
            return_val = '-STREAM-' + stream
            return_val = return_val + ' playpath=' + playpath
            return_val = return_val + ' pageUrl=' + pageURL
            return_val = return_val + ' swfUrl=' + swfURL
            return_val = return_val + ' live=1'
        }        
        return return_val
    }
    
    String process_for_SWF_PLAYPATH_STREAMER(
        String htmlText,
        String rgxMatcher,
        String pageUrl,
        String swfUrlPostfix
    ) {        
        def return_val = '-NOTFOUND-'        
        def matcher = htmlText =~ rgxMatcher
        if (matcher.count > 0) {
            
            def swfUrl = matcher[0][1] + swfUrlPostfix
            def playpath = fix_playpath(matcher[0][2])
            def stream = matcher[0][3]
            
            return_val = '-STREAM-' + stream
            return_val = return_val + ' playpath=' + playpath
            return_val = return_val + ' pageUrl=' + pageUrl
            return_val = return_val + ' swfUrl=' + swfUrl
            return_val = return_val + ' live=1'
        }        
        return return_val
    }
    
    
    WebResourceContainer extractItems(URL resourceUrl, int maxItemsToRetrieve) {
    	
		log("Parsing with SkysportsPlus V${getVersion()}")
	
		StartETime = System.currentTimeMillis()
		ETimer2()	

		ucasterUri = ""
		mipsUri = ""
		liveflashUri =""

		def noevents = 0
		
		def genurls = 1
		def curDate = new Date(System.currentTimeMillis()+300000)
		olditems = []
		if (newitems){
			def newitemssize = newitems.size()
			def nli = newitems.iterator()
			while (nli.hasNext()){
				def newEntry = nli.next()
				if(newEntry.getAdditionalInfo()['XexpiresImmediately']!= true) continue
				def SavedExpiryDate = newEntry.getAdditionalInfo()['XexpiresOn']
				if(SavedExpiryDate > new Date(0) && curDate >= SavedExpiryDate) continue
				olditems << newEntry
			}
			def olditemssize = olditems.size()
			log ( olditemssize + " items saved, " + (newitemssize - olditemssize) +  " expired" )
			olditems = olditems.drop(olditemssize-300)
			newitems = olditems
		}
		
		
		while(1) {
			def test_text = openURL(new URL("http://www.dogpile.com"),
				"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")
			def testMatch = test_text ==~ '(?s).*?Dogpile Web Search.*?'
			if (testMatch) break
		}
			
		List<WebResourceItem> items = []
		short time = 0
		def itemsAdded = 0
		def channel_image = ""
		def srcUrl = ""
		def channel_title_text = ""
		long Refreshi = 0
		long Refresha = 0


		def parmMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?skysports\\.plus.*?genurls=([0-1])'
		def parmMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?skysports\\.plus.*?genurls=[0-1].*?'
		if (parmMatch){
		    genurls = parmMatcher[0][1].trim()  
		}
		
		parmMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?skysports\\.plus.*?noevents=1'
		parmMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?skysports\\.plus.*?noevents=1.*?'
		if (parmMatch){
		    noevents = 1  
		}
		
		parmMatcher = resourceUrl =~ '^http://www.skysports.plus.*?refresh=([0-9]+)'
		parmMatch = resourceUrl ==~ '^http://www.skysports.plus.*?refresh=[0-9]+.*?'
		if (parmMatch){
			Refreshi = parmMatcher[0][1].trim().toLong()
			long curTime=System.currentTimeMillis()/60000
			Refresha = (System.currentTimeMillis()/60000) + Refreshi + 5
		}

		parmMatcher = resourceUrl =~ '^http://www.skysports.plus.*?time=([0-9]+)'
		parmMatch = resourceUrl ==~ '^http://www.skysports.plus.*?time=[0-9]+.*?'
		if (parmMatch){
			time = parmMatcher[0][1].trim().toShort()
			if (time < 0 || time > 24) time = 0
		}
		
		def resource_text = openURL(new URL("http://cricfree.tv"),
			"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")

		def SCHEDULE_LIST_EXTRACTOR = '(?s)width="100".*?>(.*?):(.*?):\\d\\d<.*?width="550">(.*?)<.*?underline.>(.*?)<'
		def schedule_list_matcher = resource_text =~ SCHEDULE_LIST_EXTRACTOR
		def sched_count = schedule_list_matcher.count
		
		def CHANNEL_LIST_EXTRACTOR = '(?s)<li><a href="(.*?)".*?</li>'
		def channel_list_matcher = resource_text =~ CHANNEL_LIST_EXTRACTOR
 		
		def channel_count = channel_list_matcher.count
		

		for (channel_number in 0..<channel_count) {			

			if (ETimer() > 86000){
				log ("Time Limit of 90 Seconds Reached") 
				println "\r\nTime Limit of 90 Seconds Reached\r\n"
				break
			}


			srcUrl = channel_list_matcher[channel_number][1]

			if (srcUrl.contains("index.php")) {
			continue;
			}

			srcUrl = srcUrl.replaceAll("http://cricfree.eu", "")
			
			def channel_title = srcUrl

			channel_title = channel_title.replaceAll("/", "")
			channel_title = channel_title.replaceAll("live", "")
			channel_title = channel_title.replaceAll("sports-streaming", "")
			channel_title = channel_title.replaceAll("streaming", "")
			channel_title = channel_title.replaceAll("stream", "")
			channel_title = channel_title.replaceAll("tennis", "")
			channel_title = channel_title.replaceAll("football", "")
			channel_title = channel_title.replaceAll("rugby", "")
			channel_title = channel_title.replaceAll("golf", "")
			channel_title = channel_title.replaceAll("american", "")
			channel_title = channel_title.replaceAll("boxing", "")                        
			channel_title = channel_title.replaceAll("basketball", "")
			channel_title = channel_title.replaceAll("manchester", "")
			channel_title = channel_title.replaceAll("united", "")
			channel_title = channel_title.replaceAll("city", "")
			channel_title = channel_title.replaceAll("chelsea", "")
			channel_title = channel_title.replaceAll("pool", "")
			channel_title = channel_title.replaceAll("free", "")
			channel_title = channel_title.replaceAll(".php", "")
			channel_title = channel_title.replaceAll("-", "")
				
			channel_image = "/" + channel_title + ".png"                                          
				
			def channel_cache_key = channel_title                        
	  
			def match_title_1 = ""
			def match_title_2 = ""

			if (channel_title == "skysports1") {
				match_title_1 = "Sky"
				match_title_2 = "1"
				channel_title = "ss1"
			}
			else
			if (channel_title == "skysports2") {
				match_title_1 = "Sky"
				match_title_2 = "2"
				channel_title = "ss2"
			}
			else
			if (channel_title == "skysports3") {
				match_title_1 = "Sky"
				match_title_2 = "3"
				channel_title = "ss3"
			}
			else
			if (channel_title == "skysports4") {
				match_title_1 = "Sky"
				match_title_2 = "4"
				channel_title = "ss4"
			}
			else
			if (channel_title == "skysportsnews") {
				match_title_1 = "Sky"
				match_title_2 = "ews"
				channel_title = "ssn"
			}
			else
			if (channel_title == "skysportsf1") {
				match_title_1 = "Sky"
				match_title_2 = "F1"
				channel_title = "sf1"
			}
			else
			if (channel_title == "espn") {
				match_title_1 = "E"
				match_title_2 = "UK"
				channel_title = "euk"
			}
			else
			if (channel_title == "eurosports") {
				match_title_1 = "uro"
				match_title_2 = "1"
				channel_title = "eu1"
			}
			else
			if (channel_title == "eurosports2") {
				match_title_1 = "uro"
				match_title_2 = "2"
				channel_title = "eu2"
			}
			else
			if (channel_title == "setantacanada") {
				match_title_1 = "anta"
				match_title_2 = "Ca"
				channel_title ="sec"
			}
			else
			if (channel_title == "setantahongkong") {
				match_title_1 = "anta"
				match_title_2 = "sia"
				channel_title = "seh"
			}
			else
			if (channel_title == "setantaaustralia") {
				match_title_1 = "anta"
				match_title_2 = "us"
				channel_title = "sea"
			}
			else
			if (channel_title == "setantaireland") {
				match_title_1 = "anta"
				match_title_2 = "re"
				channel_title = "sei"
			}
			else
			if (channel_title == "espnusa") {
				match_title_1 = "E"
				match_title_2 = "USA"
				channel_title = "eus"
			}
			else
			if (channel_title == "tenaction") {
				match_title_1 = "en"
				match_title_2 = "cti"
				channel_title = "10a"
			}
			else
			if (channel_title == "tensports") {
				match_title_1 = "en"
				match_title_2 = "por"
				channel_title = "10s"
			}
			else
			if (channel_title == "tencricket") {
				match_title_1 = "en"
				match_title_2 = "ick"
				channel_title = "10c"
			}
			else
			if (channel_title == "starsports") {
				match_title_1 = "tar"
				match_title_2 = "ort"
				channel_title = "sts"
			}
			else
			if (channel_title == "ipl") {
				match_title_1 = "IPL"
				match_title_2 = "ive"
			}
			else
			if (channel_title == "ch1") {
				match_title_1 = "annel"
				match_title_2 = " 1"
			}
			else
			if (channel_title == "ch2") {
				match_title_1 = "annel"
				match_title_2 = " 2"
			}
			else
			if (channel_title == "ch3") {
				match_title_1 = "annel"
				match_title_2 = "3"
			}
			else
			if (channel_title == "ch4") {
				match_title_1 = "annel"
				match_title_2 = "4"
			}
			else
			if (channel_title == "ch5") {
				match_title_1 = "annel"
				match_title_2 = "5"
			}
			else
			if (channel_title == "ch6") {
				match_title_1 = "annel"
				match_title_2 = "6"
			}
			else
			if (channel_title == "ch7") {
				match_title_1 = "annel"
				match_title_2 = "7"
			}
			else
			if (channel_title == "ch8") {
				match_title_1 = "annel"
				match_title_2 = "8"
			}
			else
			if (channel_title == "ch9") {
				match_title_1 = "annel"
				match_title_2 = "9"
			}
			else
			if (channel_title == "ch10") {
				match_title_1 = "annel"
				match_title_2 = "10"
			}
			else
			if (channel_title == "ch11") {
				match_title_1 = "annel"
				match_title_2 = "11"
			}
			else
			if (channel_title == "ch12") {
				match_title_1 = "annel"
				match_title_2 = "12"
			}
			else channel_title = "ch99"
			
			channel_title_text = ""
			short schedules = 0

			for (schedule_number in 0..<schedule_list_matcher.count){
				if (schedule_list_matcher[schedule_number][4].contains(match_title_1) && schedule_list_matcher[schedule_number][4].contains(match_title_2)) {
				
					short shour = schedule_list_matcher[schedule_number][1].toShort() + time 
					if (shour < 0) shour = shour + 24
					if (shour > 23) shour = shour - 24
					if ( time == 0 ){
						channel_title_text = channel_title_text + "*" + shour + ":" + schedule_list_matcher[schedule_number][2] +" GMT-" + schedule_list_matcher[schedule_number][3] 
					}
					else{
						channel_title_text = channel_title_text + "*" + shour + ":" + schedule_list_matcher[schedule_number][2] + "-" + schedule_list_matcher[schedule_number][3] 
					}
					schedules = schedules + 1
				}
				if (schedules == 2) break
			}
			
			if (channel_title_text == "") {
				if (noevents == 0 && channel_title.contains("ch")) continue  
				channel_title_text = "*No Events Scheduled*"
			}

			def channel_name = channel_title + channel_title_text


			def itemkey = "SkysportsPlus_" + channel_name

			WebResourceItem item = new WebResourceItem(title: channel_name, 
				additionalInfo: ['itemkey':itemkey,channelURL: BASE_URL + srcUrl, 
					thumbnailUrl: BASE_IMAGE_URL + channel_image, 
					cacheKey: "SkysportsPlus_" + channel_cache_key, 'refresha':Refresha])

			item.additionalInfo.put('gen',"false")
			if(olditems && itemkey){
				for (int oij=olditems.size(); oij > 0; oij--){
					String olditem = olditems.getAt(oij-1).toString()
					if(olditem.contains(itemkey)){
						item.additionalInfo.put('oindx',oij-1)
						if (genurls) item.additionalInfo.put('gen',"true")
						break
					}
				}
			}

			items << item
			itemsAdded++
		}                
 
		def Refreshat
		if (Refreshi == 0){
			log ("Folder Refresh Set to Console Default")
			Refreshat = "Console Default time"
		}
		else{
			Refreshat = new Date(Refresha*60000).format("H:mm 'on' E M/dd/yyyy ").trim()
			log ("Folder Refresh Set to " + Refreshat )
		}
		
		if (itemsAdded == 0 || Refreshi != 0){
			srcUrl = "http://lastitem"
			if (itemsAdded == 0) channel_image = "https://sites.google.com/site/serviiorss/noevents.jpg"
			else channel_image = "https://sites.google.com/site/serviiorss/nomoreitems.jpg"
			
			
			channel_title_text = "Next Refresh at $Refreshat"
			if (itemsAdded == 0) log ("ADDED 'NO EVENTS' - $channel_title_text")
			else log ("ADDED 'NO MORE ITEMS' - $channel_title_text")
			
			WebResourceItem item = new WebResourceItem(title: channel_title_text, 
				additionalInfo: ['channelURL':srcUrl,'thumbnailUrl':channel_image ,'refresha':Refresha])

			item.additionalInfo.put('gen',"false")
			items << item
		}

		ETimer("Total $itemsAdded Items Found")
		
        return new WebResourceContainer(title: "SkysportsPlus", items: items)
    }
    
    ContentURLContainer extractUrl(WebResourceItem item, PreferredQuality requestedQuality) {
    
		def srcUrl = item.additionalInfo.channelURL
		def thumbnailUrl = item.additionalInfo.thumbnailUrl
		def cacheKey = item.additionalInfo.cacheKey 
		def rtmpUrl = ""
		long Refresha = item.getAdditionalInfo()['refresha']
		Date expiryDate
		def expiresImmediately
		
		String gen = item.getAdditionalInfo()['gen']

		if(gen == "false"){
			println "\r\nExtracting URL"
		
			if (srcUrl.contains("http://lastitem")){
			if (Refresha > 0) expiryDate = new Date(Refresha * 60000)
			rtmpUrl = "rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/v00/reflector:53708"
			secCode = "abcdefghi"
			cacheKey = "http://lastitem_" + secCode
			expiresImmediately = false
		}
		else{
			log("Source Link: $srcUrl")

			if (!URLExists(srcUrl)) {
				log (srcUrl + " is DEADLINK")
				println srcUrl + " is DEADLINK"
				return null
			}
			
			def srcUrl_text = openURL( new URL(srcUrl),
				"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")        
		  
			def url_found = 0          
			
			while (url_found == 0) {
				
				if (channelOffline(srcUrl_text, '<h1 class="center">This channel is offline\\.</h1>')
					|| channelOffline(srcUrl_text, '<h4 class=.*?THIS CHANNEL IS CURRENTLY OFFLINE</h4>')
					) {
					log (srcUrl + " is OFFLINE")
					println srcUrl + " is OFFLINE"
					return null
				}
				
				if (streamNotSupported(srcUrl_text, '<media url="rtmfp://.*?/>')
					|| streamNotSupported(srcUrl_text, '<script.*?src=".*?player\\.ooyala\\.com.*?"></script>')                    
					) {
					log (srcUrl + " is NOTSUPPORTED")
					println srcUrl + " is NOTSUPPORTED"
					return null
				}

				
				def linkMatcher = srcUrl_text =~ '(?s)<table align="center".*?<iframe.*?src="(.*?)"'
				if(!linkMatcher){
					println "No src= in " + srcUrl
					log ("No src= in " + srcUrl)
					return
				}
				srcUrl = linkMatcher[0][1]

				log("Source Link 2: $srcUrl")
				
				if (!URLExists(srcUrl)) {
					log (srcUrl + " is DEADLINK")
					println srcUrl + " is DEADLINK"
					return null
				}
				srcUrl_text = openURL( new URL(srcUrl),
				"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 

				if (srcUrl_text == "") {
					log (srcUrl + " NOT FOUND")
					println srcUrl + " NOT FOUND"
					return null
				}            
			


				def headMatcher = srcUrl_text =~ '(?s)(.*?)></.*?' 
					
				println headMatcher[0][1]
					

				def returned_url = '-NOTFOUND-' 

				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						'<script.*?channel="(.*?)".*?src=".*?yukons\\.net.*?"></script>',
						(String[])[    
						    'rtmp://198.144.153.139:1935/kuyo',
						],
						'http://www.yukons.net?fileid=',
						'http://yukons.net/yukplay.swf'
					)
				}
				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						'<script.*?fid="(.*?)".*?src=".*?yycast\\.com.*?"></script>',
						(String[])[    

						    'rtmp://212.7.212.37:1935/live',
							
						],
						'http://www.yycast.com/embed.php?fileid=',
						'http://cdn.yycast.com/player/player.swf'
					)
				}
				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						"javascript:popUp.*?yycast\\.com/(.*?)'\\)",
						(String[])[    
							'rtmp://212.7.212.37:1935/live',
						],
						'http://www.yycast.com/embed.php?fileid=',
						'http://cdn.yycast.com/player/player.swf'
					)
				}       
				
				if (returned_url == '-NOTFOUND-') {
					def liveMatcher = srcUrl_text =~ "<script.*?channel='(.*?)'.*?user='(.*?)'.*?src='.*?jimey\\.tv.*?'></script>"
					def return_val = '-NOTFOUND-'        
					if (liveMatcher.count > 0) {
					

						def referrer = srcUrl
						srcUrl= "http://jimey.tv/player/embedplayer.php?channel=" + liveMatcher [0][1] + "&user=" + liveMatcher[0][2] +"&width=620&height=490"
						log("Source Link 3: $srcUrl")

						if (!URLExists(srcUrl)) {
							log (srcUrl + " is DEADLINK")
							println srcUrl + " is DEADLINK"
							return null
						}
						
						println "open link " + srcUrl
						

						srcUrl_text = OpenProtURL(srcUrl,referrer)
				
						
						def errorMatch = srcUrl_text ==~ '(?s).*?channel has been deleted.*?'
						if (errorMatch){
							log ("jimey - Channel Deleted - $secUrl")	
							return null
						}
						
						
						liveMatcher = srcUrl_text =~ "value='file=(.*?)&.*?"
						
						if(!liveMatcher){
							println "No Playpath in " + srcUrl
							log("No Playpath in " + srcUrl)
							return
						}
						
						secCode = liveMatcher [0][1]
						
						returned_url = "-STREAM-rtmpe://64.191.80.10/edge playpath=" + secCode + " swfurl=http://jimey.tv/player/fresh.swf pageUrl=http://www.jimey.tv live=1"
						println returned_url
					} 
				}

/*				
				does not work

				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						"<javascript'>.*?channel='(.*?)'",
						(String[])[    
						'rtmp://109.201.135.2/edge'
						],
						'http://www.yycast.com/embed.php?fileid=',
						'http://jimey.tv/player/fresh.swf'
					)
				}       
*/				

				if (returned_url == '-NOTFOUND-') {
					def secCode = srcUrl_text =~ '[SsRrCc]="http://leton.tv/player.*?streampage=(.*?)"'
					
					def return_val = '-NOTFOUND-'        
					if (secCode.count > 0) {

						srcUrl = "http://leton.tv/player.php?streampage=" + 
						
						log("Source Link 3: $srcUrl")
						
						String linkHtml = new URL(srcUrl).getText()
						def errorMatch = linkHtml ==~ '(?s).*?letonban.png.*?'
						if (errorMatch){
							log ("LETON - Video Banned - $secUrl")	
							return null
						}
						def rtmpMatcher = linkHtml =~ /(?s)testkey=(.*?)'.*?/
						if(!rtmpMatcher){
							log ("LETON - No testkey in $secUrl")
							return null
						}
						String rtmpKey = rtmpMatcher[0][1].trim()

						def secMatcher = linkHtml =~ /(?s)'file','(.*?)'.*?/
						if(!secMatcher){
							println "No Playpath in $secUrl" 
							log ("No Playpath in $secUrl")
							return
						}
						secCode = secMatcher[0][1].trim()

						returned_url = "-STREAM-rtmp://46.165.230.1/pull?testkey=" + rtmpKey + " swfUrl=http://files.leton.tv/player.swf pageUrl=files.leton.tv playpath=" + secCode 
						println returned_url
					} 
				}
				

				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						"<script.*?id='(.*?)'.*?src='.*?goodcast\\.org.*?'",
						(String[])[  
							'rtmp://94.242.253.139:1935/liverepeater',
						],
						'http://goodcast.org/stream.php?id=',
						'http://cdn.goodcast.org/player.swf'
					)
				}
				

				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						"<script.*?channel='(.*?)'.*?src='.*?ezcast\\.tv.*?'",
						(String[])[  
							'rtmp://64.191.80.10/live',
						],
						'http://www.ezcast.tv/embedded/',
						'http://www.ezcast.tv/static/scripts/eplayer.swf conn=S:OK'
					)
				}
				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						"<script.*?fid='(.*?)'.*?src='.*?reyhq\\.com.*?'",
						(String[])[  
							'rtmp://89.248.172.239/live',
						],
						'http://www.reyhq.com/fid=',
						'http://www.reyhq.com/player/player-licensed.swf'
					)
				}
				
				if (returned_url == '-NOTFOUND-') {
					def liveMatcher = srcUrl_text =~ "<script.*?fid='(.*?)'.*?src='.*?reyhq\\.com.*?'></script>"
					def return_val = '-NOTFOUND-'        
					if (liveMatcher.count > 0) {
					

						srcUrl= "http://www.reyhq.com/embed.php?live=" + liveMatcher [0][1] + "&vw=620&vh=490"
						log("Source Link 3: $srcUrl")

						if (!URLExists(srcUrl)) {
							log (srcUrl + " is DEADLINK")
							println srcUrl + " is DEADLINK"
							return null
						}
						
						println "open link " + srcUrl
						
						srcUrl_text =  openURL(new URL(srcUrl),
								"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")

				
						
						def errorMatch = srcUrl_text ==~ '(?s).*?channel has been deleted.*?'
						if (errorMatch){
							log ("reyhq - Channel Deleted - $secUrl")	
							return null
						}

						
						liveMatcher = srcUrl_text =~ "'file':.*?'(.*?)[\\.'].*?'streamer':.*?'(.*?)'.*?"
						
						if(!liveMatcher){
							println "No Playpath in " + srcUrl
							log("No Playpath in " + srcUrl)
							return
						}
						
						secCode = liveMatcher [0][1]
						
						returned_url = "-STREAM-" + liveMatcher[0][2] + " playpath=" + secCode + " swfurl=http://www.reyhq.com/player/player-licensed.swf  pageUrl=http://www.reyhq.com live=1"
						println returned_url
					} 
				}

				if (returned_url == '-NOTFOUND-') {
					def liveMatcher = srcUrl_text =~ '<script.*?id="(.*?)".*?src=".*?castalba\\.tv.*?"></script>'
					def return_val = '-NOTFOUND-'        
					if (liveMatcher.count > 0) {
					
						srcUrl= "http://www.castalba.tv/embed.php?cid=" + liveMatcher [0][1] + "&wh=620&ht=490&r=cricfree.tv"
						
						log("Source Link 3: $srcUrl")

						if (!URLExists(srcUrl)) {
							log (srcUrl + " is DEADLINK")
							println srcUrl + " is DEADLINK"
							return null
						}
						
						println "open link " + srcUrl
						
						srcUrl_text = OpenProtURL(srcUrl,"http://www.cricfree.tv")
						
						
						
						liveMatcher = srcUrl_text =~ "'file':.*?'(.*?)'.*?'streamer':.*?'(.*?)'.*?"
						
						if(!liveMatcher){
							println "No Playpath in " + srcUrl
							log("No Playpath in " + srcUrl)
							return
						}
						
						secCode = liveMatcher [0][1]
						
						returned_url = "-STREAM-" + liveMatcher[0][2] + " playpath=" + secCode + " swfurl=http://www.udemy.com/static/flash/player5.9.swf pageUrl=http://www.castalba.tv live=1"
						println returned_url
					} 
				}
				
				if (returned_url == '-NOTFOUND-') {
					def liveMatcher = srcUrl_text =~ "<script.*?channel='(.*?)'.*?g='(.*?)'.*?src='.*?liveflash\\.tv.*?'></script>"
					def return_val = '-NOTFOUND-'        
					if (liveMatcher.count > 0) {
					
						srcUrl= "http://www.liveflash.tv/embedplayer/" + liveMatcher [0][1] + "/" + liveMatcher [0][2] + "/620/490"
						
						log("Source Link 3: $srcUrl")

						if (!URLExists(srcUrl)) {
							log (srcUrl + " is DEADLINK")
							println srcUrl + " is DEADLINK"
							return null
						}
						
						println "open link " + srcUrl
						
						srcUrl_text = OpenProtURL(srcUrl,"http://www.cricfree.tv")
						
						
						liveMatcher = srcUrl_text =~ "FlashVars.*?id=(.*?)&s=(.*?)&.*?"
						
						if(!liveMatcher){
							println "No Playpath in " + srcUrl
							log("No Playpath in " + srcUrl)
							return
						}
						
						secCode = liveMatcher [0][2] + "?id=" + liveMatcher [0][1]
						
						//* now get uri if required (loadbalancer only works once)
						if(!liveflashUri){
							def linkUri = openURL( new URL("http://www.liveflash.tv:1935/loadbalancer"), 
								"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")
							println linkUri
							def uriMatcher = linkUri =~ 'redirect=(.*?)$'
							if (!uriMatcher) liveflashUri = "75.126.107.118"
							else liveflashUri = uriMatcher[0][1]
						}
						
						returned_url = "-STREAM-rtmp://" + liveflashUri + ":1935/stream playpath=" + secCode + " swfurl=http://www.liveflash.tv/resources/scripts/eplayer.swf pageUrl=http://www.liveflash.tv live=1"
						println returned_url
					} 
				}
				
				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						"onClick=\"javascript:popUp\\('.*?liveflash\\.tv/(.*?)'\\)\"></a><a.*?></a><a.*?><img.*?></a>",
						(String[])[    
							'rtmp://208.43.175.45/stream',
							'rtmp://31.204.154.63/stream',
							'rtmp://108.170.10.2/stream'
						],
						'http://www.liveflash.tv/embedplayer/',
						'http://www.liveflash.tv/resources/scripts/eplayer.swf'
					)
				} 
	

				if (returned_url == '-NOTFOUND-') {
					def liveMatcher = srcUrl_text =~ "(?s)<script.*?channel='(.*?)'.*?g='(.*?)'.*?src='.*?ucaster\\.eu.*?'></script>.*?"
					def return_val = '-NOTFOUND-'        
					if (liveMatcher.count > 0) {
						srcUrl = "http://www.ucaster.eu/embedded/" + liveMatcher [0][1] + "/" + liveMatcher [0][2] + "/620/490"
						
						log("Source Link 3: $srcUrl")

						if (!URLExists(srcUrl)) {
							log (srcUrl + " is DEADLINK")
							println srcUrl + " is DEADLINK"
							return null
						}
						
						println "open link " + srcUrl
						
						srcUrl_text = OpenProtURL(srcUrl,"http://www.cricfree.tv")

						
						liveMatcher = srcUrl_text =~ "FlashVars.*?id=(.*?)&s=(.*?)&.*?"
						
						if(!liveMatcher){
							println "No Playpath in " + srcUrl
							log("No Playpath in " + srcUrl)
							return
						}

						secCode = liveMatcher [0][2] + "?id=" + liveMatcher [0][1]
						
						//* now get uri if required (loadbalancer only works once)
						if(!ucasterUri){
							def linkUri = openURL( new URL("http://www.ucaster.eu:1935/loadbalancer"),
								"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
							println linkUri
							def UriMatcher = linkUri =~ 'redirect=(.*?)$'
							if(!UriMatcher) ucasterUri = "174.36.251.140"
							else ucasterUri = UriMatcher[0][1]
						}
						
						returned_url = "-STREAM-rtmp://" + ucasterUri + "/live playpath=" + secCode + " pageUrl=http://www.ucaster.eu swfurl=http://www.ucaster.eu/static/scripts/eplayer.swf live=1"
						println returned_url
					} 
				}
				
				if (returned_url == '-NOTFOUND-') {
					def liveMatcher = srcUrl_text =~ "(?s)<script.*?channel='(.*?)'.*?e='(.*?)'.*?src='.*?mips\\.tv.*?'></script>.*?"
					def return_val = '-NOTFOUND-'        
					if (liveMatcher.count > 0) {
						srcUrl = "http://www.mips.tv/embedplayer/" + liveMatcher [0][1] + "/" + liveMatcher [0][2] + "/620/490"
						
						log("Source Link 3: $srcUrl")

						if (!URLExists(srcUrl)) {
							log (srcUrl + " is DEADLINK")
							println srcUrl + " is DEADLINK"
							return null
						}
						
						
						println "open link " + srcUrl
						
						srcUrl_text = OpenProtURL(srcUrl,"http://www.cricfree.tv")

				
						liveMatcher = srcUrl_text =~ "FlashVars.*?id=(.*?)&s=(.*?)&.*?"
						
						if(!liveMatcher){
							println "No Playpath in " + srcUrl
							log("No Playpath in " + srcUrl)
							return
						}

						secCode = liveMatcher [0][2] + "?id=" + liveMatcher [0][1]
						
						//* now get uri if required (loadbalancer only works once)
						if(!mipsUri){
						def linkUri = openURL( new URL("http://www.mips.tv:1935/loadbalancer"),
								"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
							def UriMatcher = linkUri =~ 'redirect=(.*?)$'
							if(!UriMatcher) mipsUri = "50.23.113.212"
							else mipsUri = UriMatcher[0][1]
						}
						
						returned_url = "-STREAM-rtmp://" + mipsUri + "/live playpath=" + secCode + " pageUrl=http://www.mips.tv/ swfurl=http://mips.tv/content/scripts/eplayer.swf live=1"
						println returned_url
					} 
				}

				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						"<script.*?channel='(.*?)'.*?src='.*?mips\\.tv",
						(String[])[    
							'rtmp://mips.tv:1935/live/'
						],
						'http://www.mips.tv/',
						'http://mips.tv/content/scripts/eplayer.swf'
					)
					if (returned_url != '-NOTFOUND-'){
						//* now get uri if required (loadbalancer only works once)
						if(!mipsUri){
						def linkUri = openURL( new URL("http://www.mips.tv:1935/loadbalancer"),
								"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
							def UriMatcher = linkUri =~ 'redirect=(.*?)$'
							if(!UriMatcher) mipsUri = "50.23.113.212"
							else mipsUri = UriMatcher[0][1]
						}
						returned_url = returned_url.replaceFirst("mips.tv",mipsUri)
					}
				}
				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						'<script.*?channel="(.*?)".*?src=".*?castamp\\.com.*?"></script>',
						(String[])[    
							'rtmp://68.68.31.224/live',
							'rtmp://s31.castamp.com/live'
						],
						'http://www.castamp.com/embed.php?c=',
						'http://www.udemy.com/static/flash/player5.9.swf'
					)
				}
				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						'<script.*?id="(.*?)".*?src=".*?cast4you\\.tv.*?"></script>',
						(String[])[    
							'rtmp://31.204.128.77/liveedge',
							'rtmp://46.249.52.100/liveedge',
							'rtmp://188.122.91.23/liveedge'
						],
						'http://www.cast4you.tv/show.php?id=',
						'http://cast4you.tv/p1.swf'
					)
				}
				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						"<script.*?fid='(.*?)'; v_width=.*?src='.*?livego\\.tv.*?'></script>",
						(String[])[    
							'rtmp://5.153.10.163:1930/live',
							'rtmp://178.32.49.53:1930/liveorigin',
						],
						'http://livego.tv/embed.php?live=',
						'http://livego.tv/player/player-licensed.swf'
					)
				}

				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_PLAYPATH(
						srcUrl_text,
						'<script.*?fid="(.*?)"; v_width=.*?src=".*?castup\\.tv.*?"></script>',
						(String[])[    
							'rtmp://95.211.191.35:80/live',
							'rtmp://95.211.185.39:80/live',
							'rtmp://95.211.185.40:80/live'
						],
						'http://www.castup.tv/embed.php?u=',
						'http://i1168.photobucket.com/albums/r496/castuptv/player.swf'
					)
				}
				
				
				if (returned_url == '-NOTFOUND-') {
					returned_url = process_for_URL(
						srcUrl_text,
						"<script.*?fid='(.*?)';.*?src='.*?fcast\\.tv",
						'http://www.fcast.tv/embed.php?live='
					)
					
					if (returned_url.contains("-URL-")) {
						String temp_returned_url = returned_url
						temp_returned_url = temp_returned_url.replaceFirst("-URL-","")
						if (!URLExists(temp_returned_url)) {
							log (returned_url + " is DEADLINK")
							println returned_url + " is DEADLINK"
							return null
						}
						String temp_srcUrl_text = openURL( new URL(temp_returned_url), 
							"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")
						
						returned_url = '-NOTFOUND-'
						
						if (temp_srcUrl_text.contains('Embedding disabled for this Channel')) {                                   
							
							if (returned_url == '-NOTFOUND-') {
								returned_url = process_for_PLAYPATH(
									srcUrl_text,
									'<iframe.*?src=".*?fcast\\.tv/watch\\.php\\?live=(.*?)".*?>',
									(String[])[    
										'rtmp://37.221.166.70/live',
										'rtmp://37.221.166.69/live',
										'rtmp://109.163.236.66/live'
									],
									'http://www.fcast.tv/embed.php?live=',
									'http://www.fcast.tv/player/player-licensed.swf'
								)
							}
							if (returned_url == '-NOTFOUND-') {
								returned_url = process_for_PLAYPATH(
									srcUrl_text,
									"<script.*?fid='(.*?)';.*?src='.*?fcast\\.tv",
									(String[])[    
										'rtmp://37.221.166.70/live',
										'rtmp://37.221.166.69/live',
										'rtmp://109.163.236.66/live'
									],
									'http://www.fcast.tv/embed.php?live=',
									'http://www.fcast.tv/player/player-licensed.swf'
								)
							}                                                        
						}
						else {
							if (returned_url == '-NOTFOUND-' ) {
								returned_url = process_for_SWF_PLAYPATH_STREAMER(
									temp_srcUrl_text,
									"(?s)<script.*?SWFObject\\('(.*?).php',.*?addVariable\\('file','(.*?)'\\);.*?addVariable\\('streamer','(.*?)'\\);",
									current_url,
									'.php'
								)
							}
						}
					}
				}                       

				if (returned_url == 'DOES NOT WORK') {
					returned_url = process_for_URL(
						srcUrl_text,
						'(?s)src="http://www.hdmytv.com/channel.php\\?file=(.*?)"',
						'http://www.hdmytv.com/channel.php?file='
					)
					if (returned_url.contains("-URL-")) {
						String temp_returned_url = returned_url
						temp_returned_url = temp_returned_url.replaceFirst("-URL-","")
						if (!URLExists(temp_returned_url)) {
							log (returned_url + " is DEADLINK")
							println returned_url + " is DEADLINK"
							return null
						}

						println "1-extracted protected channel url #2, now read it \r\n" + temp_returned_url
						println "referrer 1=" + srcUrl

						String temp_srcUrl_text = OpenProtURL(temp_returned_url,srcUrl)


						def codMatcher = temp_srcUrl_text =~ '(?s)src="(.*?)"'

						println "2-opened channel url #2, extracted protected embed url #3, now read it \r\n" + codMatcher[0][1]
						println "referrer2 channel=" + temp_returned_url
						temp_srcUrl_text = OpenProtURL(codMatcher[0][1],temp_returned_url)
												

						codMatcher = temp_srcUrl_text =~ "(?s)function getURL03.*?var.sUrl.=.'(.*?)'.*?var.cod1.=.'(.*?)'.*?var.cod2.=.'(.*?)'.*?var.cod4.=.'(.*?)'"
						
						if (codMatcher.count == 0) {					
							log (temp_returned_url + " values Not Found")
							println temp_returned_url + " values Not Found - Probably Removed Channel"
							println "embed text =" + temp_srcUrl_text
							return null
						}
						
						def var1 = codMatcher [0][2]
						var1 = var1.replaceAll("=", "%3D")
						var1 = var1.replaceAll('\\+', "%2B")
						def var2 = codMatcher [0][3]
						var2 = var2.replaceAll("=", "%3D")
						var2 = var2.replaceAll("\\+", "%2B")
						def var4 = codMatcher [0][3]
						var4 = var4.replaceAll("=", "%3D")
						var4 = var4.replaceAll("\\+", "%2B")

						temp_returned_url = codMatcher [0][1] + "?v_cod1=" + var1 + "&v_cod2=" + var2 + "&v_cod4=" + var4
						
						if (!URLExists(temp_returned_url)) {
							log (returned_url + " is DEADLINK")
							println returned_url + " is DEADLINK"
							return null
						}
						
						println "3-opened embed url #3, extracted vars and built url02 url #4, now read it \r\n" + temp_returned_url
						println "referrer3 embed=" + codMatcher[0][1]

						
						temp_srcUrl_text = OpenProtURL(temp_returned_url,codMatcher[0][1])

						//temp_srcUrl_text = openURL( new URL(temp_returned_url), 
						//	"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")
						
						returned_url = '-NOTFOUND-'
						println temp_srcUrl_text
						  
						returned_url = process_for_PLAYPATH(
							temp_srcUrl_text,
							'result1":"(.*?)".*?',
							(String[])[    
								'rtmp://46.19.140.146:1735/vod'
								],
							'http://www.hdmytv.com/embed.php?live=',
							'http://www.hdmytv.com/player-hd.swf'
						)
						println "4-opened url02 url #4, extracted playpath and built rtmp link" 
						println "referrer4 url02 =" + temp_returned_url
					}
				}

				if (returned_url == '-NOTFOUND-') { 
					returned_url = process_for_URL(
						srcUrl_text, 
						'<pre>.*?cricfree.tv/update/(.*?)</pre>',
						'http://cricfree.tv/update/'
					)                 
				}
				 
				if (returned_url == '-NOTFOUND-') {
					def srcMatcher = srcUrl_text =~ /(?s)src=["'](.*?)['"].*?/
					def msg = "src= "
					if(srcMatcher) msg = srcMatcher[0][1]
					log (srcUrl + " - " + msg + " NOTFOUND")
					println srcUrl + " - " + msg + " NOTFOUND"
					return null
				}            
				else if (returned_url.contains("-URL-")) {
					returned_url = returned_url.replaceFirst("-URL-","")
					def current_url = returned_url
					if (!URLExists(current_url)) {
						log (current_url + " DEADLINK")
						println current_url + " DEADLINK"
						return null
					}
					srcUrl_text = openURL( new URL(current_url), 
						"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")
				}
				else if (returned_url.contains("-STREAM-")) {
					rtmpUrl = returned_url
					url_found = 1
				}         
			}   
	 
			
			if (rtmpUrl.contains('-STREAM-')) {
				rtmpUrl = rtmpUrl.replaceFirst("-STREAM-", "")
			}
			else {
				return null
			}
		
			log("Extracted url: " + srcUrl)
		
		
			cacheKey = cacheKey + "_" + secCode
		
			expiresImmediately = true
		
			}
	
			item.additionalInfo.put('XcontentUrl',rtmpUrl)
			item.additionalInfo.put('XthumbnailUrl',thumbnailUrl)
			item.additionalInfo.put('XexpiresOn',expiryDate)
			item.additionalInfo.put('XexpiresImmediately',expiresImmediately)
			item.additionalInfo.put('XcacheKey',cacheKey)
			def oindx = item.getAdditionalInfo()['oindx']
			if(oindx){
				newitems[oindx] = item
			}
			else {
				oindx = newitems.size()
				item.additionalInfo.put('oindx',oindx)
				newitems << item
			}
		
		}//END of non gen EXTRACT

		else{   //START OF gen GENERATE
			println "\r\ngenerate url"
			log ("Generated url: " + srcUrl)
			item.additionalInfo.put('gen',"false")
			def oindx = item.getAdditionalInfo()['oindx']
			rtmpUrl = olditems.getAt(oindx).getAdditionalInfo()['XcontentUrl']
			thumbnailUrl = olditems.getAt(oindx).getAdditionalInfo()['XthumbnailUrl']
			expiryDate = olditems.getAt(oindx).getAdditionalInfo()['XexpiresOn']
			expiresImmediately = olditems.getAt(oindx).getAdditionalInfo()['XexpiresImmediately']
			cacheKey = olditems.getAt(oindx).getAdditionalInfo()['XcacheKey']
		}
	
		return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: rtmpUrl, thumbnailUrl: thumbnailUrl, 
			cacheKey: cacheKey, expiresOn: expiryDate, expiresImmediately: expiresImmediately, live: true)
	}

	   static void main(args) {
        
        SkysportsPlus extractor = new SkysportsPlus()
        
        WebResourceContainer container = extractor.extractItems( new URL("http://www.skysports.plus?refresh=120&time=16"), -1)
		
        container.getItems().each {
            ContentURLContainer result = extractor.extractUrl(it, PreferredQuality.MEDIUM)
            println result
        }
 
		WebResourceContainer container2 = extractor.extractItems( new URL("http://www.skysports.plus?refresh=120&time=16"), -1)
		
        container2.getItems().each {
            ContentURLContainer result2 = extractor.extractUrl(it, PreferredQuality.MEDIUM)
            println result2
        }

   }
   
 }
